(function () {
  const form = document.getElementById('contact-form');
  if (form) {
    form.addEventListener('submit', function (e) {
      e.preventDefault();

      const fields = [
        { id: 'name', required: true, validate: (v) => v.trim().length >= 2, msg: 'Введите имя (не короче 2 символов)' },
        { id: 'phone', required: true, validate: (v) => /[0-9()+\-\s]{6,}/.test(v), msg: 'Укажите телефон' },
        { id: 'email', required: false, validate: (v) => v === '' || /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(v), msg: 'Некорректный email' },
        { id: 'device', required: true, validate: (v) => v !== '', msg: 'Выберите тип устройства' },
        { id: 'message', required: true, validate: (v) => v.trim().length >= 6, msg: 'Опишите проблему подробнее' }
      ];

      let isValid = true;
      fields.forEach(({ id, validate, required, msg }) => {
        const input = document.getElementById(id);
        const error = document.querySelector(`[data-error-for="${id}"]`);
        if (!input || !error) return;
        const value = input.value || '';
        const ok = validate(value);
        if (!ok && (required || value !== '')) {
          isValid = false;
          error.textContent = msg;
          input.setAttribute('aria-invalid', 'true');
        } else {
          error.textContent = '';
          input.removeAttribute('aria-invalid');
        }
      });

      const success = document.getElementById('form-success');
      if (isValid) {
        const successAlert = document.getElementById('successAlert');
        if (successAlert) {
          successAlert.classList.remove('d-none');
        }
        
        if (success) {
          success.hidden = false;
          success.focus && success.focus();
        }
        form.reset();
      } else {
        if (success) success.hidden = true;
      }
    });
  }
})();